/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.FromNativeContext;
import com.sun.jna.Klass$JNIEnv;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.StructureWriteContext$MethodResultContext;
import com.sun.jna.Union$PointerType;
import com.sun.jna.WeakMemoryHolder;
import com.sun.jna.internal.Cleaner;
import java.io.Closeable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import melotr.MCDARichHelper;

public class Memory
extends Pointer
implements Closeable {
    private static final WeakMemoryHolder buffers;
    protected long size;
    private final Cleaner.Cleanable cleanable;
    private static final Map<Long, Reference<Memory>> allocatedMemory;

    @Override
    public double getDouble(long offset) {
        this.boundsCheck(offset, 8L);
        return super.getDouble(offset);
    }

    public long size() {
        return this.size;
    }

    @Override
    public void write(long bOff, Pointer[] buf, int index, int length) {
        this.boundsCheck(bOff, length * Native.POINTER_SIZE);
        super.write(bOff, buf, index, length);
    }

    @Override
    public byte getByte(long offset) {
        this.boundsCheck(offset, 1L);
        return super.getByte(offset);
    }

    @Override
    public void write(long bOff, long[] buf, int index, int length) {
        this.boundsCheck(bOff, (long)length * 8L);
        super.write(bOff, buf, index, length);
    }

    @Override
    public void setWideString(long offset, String value) {
        this.boundsCheck(offset, ((long)value.length() + 1L) * (long)Native.WCHAR_SIZE);
        super.setWideString(offset, value);
    }

    @Override
    public void setFloat(long offset, float value) {
        this.boundsCheck(offset, 4L);
        super.setFloat(offset, value);
    }

    @Override
    public Pointer share(long offset) {
        return this.share(offset, this.size() - offset);
    }

    @Override
    public void setPointer(long offset, Pointer value) {
        this.boundsCheck(offset, Native.POINTER_SIZE);
        super.setPointer(offset, value);
    }

    @Override
    public void setByte(long offset, byte value) {
        this.boundsCheck(offset, 1L);
        super.setByte(offset, value);
    }

    public Memory(long size) {
        this.size = size;
        if (size <= 0L) {
            throw new IllegalArgumentException(CallbackThreadInitializer.l(Klass$JNIEnv.n("\u247c\u7187\u6645\u9fe5\u9b9d\uff1a\u7c90\u18b1\u6405\u3e73\uacc8\u6d09\u98b3\u09db\u6ea9\ue9c9\u571c\u598b\ud69c\u9e98\u584a\ufd5f\u4481\u2525\u522a\u8511\u0857\ua7c2\ue5ea\u4757\u39b6\ube0c\u74fc\u5005\u24c4\u9320\ufbeb\ud88f\u6f99\u1365\ub123")));
        }
        this.peer = Memory.malloc(size);
        if (this.peer == 0L) {
            throw new OutOfMemoryError(MCDARichHelper.l(Klass$JNIEnv.n("\u245a\u71cd\u6663\u9fa3\u9bb5\uff48\u7ce0\u18fe\u6422\u3e36\uaca3\u6d5e\u989f\u0992\u6e8d\ue98e")) + size + CallbackThreadInitializer.l(Klass$JNIEnv.n("\u240d\u7199\u6640\u9fee\u9b8b\uff18")));
        }
        allocatedMemory.put(this.peer, new WeakReference<Memory>(this));
        this.cleanable = Cleaner.getCleaner().register(this, new MemoryDisposer(this.peer));
    }

    @Override
    public void read(long bOff, float[] buf, int index, int length) {
        this.boundsCheck(bOff, (long)length * 4L);
        super.read(bOff, buf, index, length);
    }

    @Override
    public void setLong(long offset, long value) {
        this.boundsCheck(offset, 8L);
        super.setLong(offset, value);
    }

    @Override
    public void setDouble(long offset, double value) {
        this.boundsCheck(offset, 8L);
        super.setDouble(offset, value);
    }

    @Override
    public void setInt(long offset, int value) {
        this.boundsCheck(offset, 4L);
        super.setInt(offset, value);
    }

    @Override
    public void read(long bOff, long[] buf, int index, int length) {
        this.boundsCheck(bOff, (long)length * 8L);
        super.read(bOff, buf, index, length);
    }

    @Override
    public void write(long bOff, int[] buf, int index, int length) {
        this.boundsCheck(bOff, (long)length * 4L);
        super.write(bOff, buf, index, length);
    }

    protected static long malloc(long size) {
        return Native.malloc(size);
    }

    @Override
    public String toString() {
        return MCDARichHelper.l(Klass$JNIEnv.n("\u8ee6\u8a8a\u9323\uf4c2\uc0c2\u6f80\ub3d6\ua221\u79d2\u6741\ue319\u8bc6")) + Long.toHexString(this.peer) + CallbackThreadInitializer.l(Klass$JNIEnv.n("\u8e93\u8a99")) + this.size + MCDARichHelper.l(Klass$JNIEnv.n("\u8ed4\u8af7\u9345\uf4aa\uc0b7\u6fe1\ub3f8"));
    }

    @Override
    public void setChar(long offset, char value) {
        this.boundsCheck(offset, Native.WCHAR_SIZE);
        super.setChar(offset, value);
    }

    @Override
    public void read(long bOff, byte[] buf, int index, int length) {
        this.boundsCheck(bOff, (long)length * 1L);
        super.read(bOff, buf, index, length);
    }

    @Override
    public void read(long bOff, int[] buf, int index, int length) {
        this.boundsCheck(bOff, (long)length * 4L);
        super.read(bOff, buf, index, length);
    }

    @Override
    public void write(long bOff, char[] buf, int index, int length) {
        this.boundsCheck(bOff, length * Native.WCHAR_SIZE);
        super.write(bOff, buf, index, length);
    }

    @Override
    public Pointer share(long offset, long sz) {
        this.boundsCheck(offset, sz);
        return new SharedMemory(offset, sz);
    }

    static {
        allocatedMemory = new ConcurrentHashMap<Long, Reference<Memory>>();
        buffers = new WeakMemoryHolder();
    }

    protected Memory() {
        this.cleanable = null;
    }

    @Override
    public short getShort(long offset) {
        this.boundsCheck(offset, 2L);
        return super.getShort(offset);
    }

    @Override
    public float getFloat(long offset) {
        this.boundsCheck(offset, 4L);
        return super.getFloat(offset);
    }

    @Override
    public ByteBuffer getByteBuffer(long offset, long length) {
        this.boundsCheck(offset, length);
        ByteBuffer b = super.getByteBuffer(offset, length);
        buffers.put(b, this);
        return b;
    }

    @Deprecated
    protected void dispose() {
        this.close();
    }

    public String dump() {
        return this.dump(0L, (int)this.size());
    }

    @Override
    public void write(long bOff, byte[] buf, int index, int length) {
        this.boundsCheck(bOff, (long)length * 1L);
        super.write(bOff, buf, index, length);
    }

    public static void disposeAll() {
        ArrayList<Reference<Memory>> refs = new ArrayList<Reference<Memory>>(allocatedMemory.values());
        for (Reference reference : refs) {
            Memory m = (Memory)reference.get();
            if (m == null) continue;
            m.close();
        }
    }

    @Override
    public void write(long bOff, double[] buf, int index, int length) {
        this.boundsCheck(bOff, (long)length * 8L);
        super.write(bOff, buf, index, length);
    }

    public boolean valid() {
        return this.peer != 0L;
    }

    @Override
    public void read(long bOff, double[] buf, int index, int length) {
        this.boundsCheck(bOff, (long)length * 8L);
        super.read(bOff, buf, index, length);
    }

    private /* synthetic */ Pointer shareReferenceIfInBounds(Pointer target) {
        if (target == null) {
            return null;
        }
        long offset = target.peer - this.peer;
        if (offset >= 0L && offset < this.size) {
            return this.share(offset);
        }
        return target;
    }

    @Override
    public long getLong(long offset) {
        this.boundsCheck(offset, 8L);
        return super.getLong(offset);
    }

    @Override
    public void close() {
        this.peer = 0L;
        if (this.cleanable != null) {
            this.cleanable.clean();
        }
    }

    @Override
    public void setString(long offset, String value, String encoding) {
        this.boundsCheck(offset, (long)Native.getBytes(value, encoding).length + 1L);
        super.setString(offset, value, encoding);
    }

    @Override
    public void write(long bOff, float[] buf, int index, int length) {
        this.boundsCheck(bOff, (long)length * 4L);
        super.write(bOff, buf, index, length);
    }

    @Override
    public String getWideString(long offset) {
        this.boundsCheck(offset, 0L);
        return super.getWideString(offset);
    }

    @Override
    public Pointer getPointer(long offset) {
        this.boundsCheck(offset, Native.POINTER_SIZE);
        return this.shareReferenceIfInBounds(super.getPointer(offset));
    }

    public Memory align(int byteBoundary) {
        if (byteBoundary <= 0) {
            throw new IllegalArgumentException(CallbackThreadInitializer.l(Klass$JNIEnv.n("\uc01b\uf0c5\u561a\u72d0\u8ab9\u041e\u742e\uc9e6\ud832\u6273\u46e1\u4c60\u115d\u8dc7\u22ac\uf1ee\u4f05\u0c11\ufcaa\ucbb7\uda99\u62e5\u4bd8\u1bfe\u6cb7\uaf23\uc531\u1973\u84e7\ub7c9\uaf0c\u036d")) + byteBoundary);
        }
        for (int i = 0; i < 32; ++i) {
            if (byteBoundary != 1 << i) continue;
            long mask = (long)byteBoundary - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            if ((this.peer & mask) != this.peer) {
                long newPeer = this.peer + (long)byteBoundary - 1L & mask;
                long newSize = this.peer + this.size - newPeer;
                if (newSize <= 0L) {
                    throw new IllegalArgumentException(MCDARichHelper.l(Klass$JNIEnv.n("\uc024\uf085\u5629\u7297\u8acb\u044d\u741c\uc9a7\ud801\u6225\u46da\u4c31\u1130\u8ddd\u2290\uf1a1\u4f2d\u0c40\ufcc7\ucba2\udabc\u62fd\u4bbc\u1ba7\u6c9c\uaf74\uc516\u1923\u8485\ub78f\uaf6d\u033a\u599d\u56a1\ua3c9\u5298\u39b9\u2384\ued6b\ud98b\udc11\ucc2f\u33a0\u43fb\udb4f\ua7fd\u737c\u5f78\u132a\u1b0d\u7cc9\ua956\u168a\ue23e")));
                }
                return (Memory)this.share(newPeer - this.peer, newSize);
            }
            return this;
        }
        throw new IllegalArgumentException(CallbackThreadInitializer.l(Klass$JNIEnv.n("\uc01b\uf0c5\u561a\u72d0\u8ab9\u041e\u742e\uc9e6\ud832\u6273\u46e1\u4c60\u115d\u8dc7\u22ac\uf1ee\u4f05\u0c11\ufcaa\ucbb7\uda99\u62e5\u4bc9\u1bb1\u6cb4\uaf25\uc532\u197f\u84e3\ub78c\uaf59\u032b\u59fd\u56ea\ua3ef\u5280")));
    }

    @Override
    public void setShort(long offset, short value) {
        this.boundsCheck(offset, 2L);
        super.setShort(offset, value);
    }

    @Override
    public void read(long bOff, short[] buf, int index, int length) {
        this.boundsCheck(bOff, (long)length * 2L);
        super.read(bOff, buf, index, length);
    }

    public static void purge() {
        buffers.clean();
    }

    @Override
    public void read(long bOff, char[] buf, int index, int length) {
        this.boundsCheck(bOff, length * Native.WCHAR_SIZE);
        super.read(bOff, buf, index, length);
    }

    @Override
    public void read(long bOff, Pointer[] buf, int index, int length) {
        this.boundsCheck(bOff, length * Native.POINTER_SIZE);
        super.read(bOff, buf, index, length);
    }

    protected void boundsCheck(long off, long sz) {
        if (off < 0L) {
            throw new IndexOutOfBoundsException(MCDARichHelper.l(Union$PointerType.H("\u28ff\ue394\u228c\u9cdf\u716f\ub2ca\u2bfb\u1c25\ub07f\ud667\u5fd3\u9d4d\u511a\u2dad\u2472\u27aa")) + off);
        }
        if (off + sz > this.size) {
            String msg = CallbackThreadInitializer.l(Union$PointerType.H("\u28c0\ue3c2\u22bb\u9c87\u7153\ub287\u2b8b\u1c37\ub05c\ud635\u5fe4\u9d0c\u512f\u2dfd\u245c\u27bc\u2f9d\u6f01\u71ec\ub63e\u518f\u8cc0\u3e9c\ua046\u3338\ua7c7\u2c97\u4df6\u3072\u9f71\u3187\ud02c\u0eee\uec89\uec57\u8b7a\u3967\ud5e0")) + this.size + MCDARichHelper.l(Union$PointerType.H("\u28e9\ue3a9\u22e6\u9cab\u7116\ub2a3\u2b89\u1c02\ub05e")) + (off + sz);
            throw new IndexOutOfBoundsException(msg);
        }
    }

    @Override
    public int getInt(long offset) {
        this.boundsCheck(offset, 4L);
        return super.getInt(offset);
    }

    protected static void free(long p) {
        if (p != 0L) {
            Native.free(p);
        }
    }

    @Override
    public void write(long bOff, short[] buf, int index, int length) {
        this.boundsCheck(bOff, (long)length * 2L);
        super.write(bOff, buf, index, length);
    }

    @Override
    public char getChar(long offset) {
        this.boundsCheck(offset, Native.WCHAR_SIZE);
        return super.getChar(offset);
    }

    @Override
    public String getString(long offset, String encoding) {
        this.boundsCheck(offset, 0L);
        return super.getString(offset, encoding);
    }

    public void clear() {
        this.clear(this.size);
    }

    private static final class MemoryDisposer
    implements Runnable {
        private long peer;

        @Override
        public synchronized void run() {
            try {
                Memory.free(this.peer);
            }
            finally {
                allocatedMemory.remove(this.peer);
                this.peer = 0L;
            }
        }

        public MemoryDisposer(long peer) {
            this.peer = peer;
        }
    }

    private class SharedMemory
    extends Memory {
        @Override
        public String toString() {
            return super.toString() + FromNativeContext.l(StructureWriteContext$MethodResultContext.u("\u9fee\ueb2b\u3641\u1bcb\u11ad\u896a\u7b86\uc070\u346f\u497b\u6404\u6664\u2e4e\ueb93")) + Memory.this.toString() + FromNativeContext.l(StructureWriteContext$MethodResultContext.u("\u9f9e"));
        }

        @Override
        protected void boundsCheck(long off, long sz) {
            Memory.this.boundsCheck(this.peer - Memory.this.peer + off, sz);
        }

        @Override
        protected synchronized void dispose() {
            this.peer = 0L;
        }

        public SharedMemory(long offset, long size) {
            this.size = size;
            this.peer = Memory.this.peer + offset;
        }
    }
}

